#include <windows>
#pragma option push -a1
#include <setupapi>
#pragma option pop
#include <assert>
#include <iostream>

using namespace std;

void displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete [] x;
  x = NULL;
}
//---------------------------------------------------------
/* A5DCBF10-6530-11D2-901F-00C04FB951ED */
static GUID GUID_DEVINTERFACE_USB_DEVICE =
{0xA5DCBF10, 0x6530, 0x11D2, {0x90, 0x1F, 0x00, 0xC0,
                              0x4F, 0xB9, 0x51, 0xED}};

/* 3ABF6F2D-71C4-462a-8A92-1E6861E6AF27 */
static GUID GUID_DEVINTERFACE_USB_HOST_CONTROLLER =
{0x3abf6f2d, 0x71c4, 0x462a, {0x8a, 0x92, 0x1e, \
                              0x68, 0x61, 0xe6, 0xaf, 0x27}};

/* F18A0E88-C30C-11D0-8815-00A0C906BED8 */
static GUID GUID_DEVINTERFACE_USB_HUB =
{0xf18a0e88, 0xc30c, 0x11d0,{0x88, 0x15, 0x00, \
                             0xa0, 0xc9, 0x06, 0xbe, 0xd8}};
//---------------------------------------------------------
DWORD memberIndex = 0;
DWORD deviceInterfaceDetailDataSize;
DWORD requiredSize;
HMODULE hSetupApi;

HDEVINFO deviceInfoSet;

SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;

int main(){

    typedef void* (__stdcall *pSetupDiGetClassDevs)
                  (IN LPGUID  ClassGuid,  OPTIONAL
                   IN PCTSTR  Enumerator,  OPTIONAL
                   IN HWND  hwndParent,  OPTIONAL
                   IN DWORD  Flags);

    typedef bool (__stdcall* pSetupDiEnumDeviceInterfaces)
                 (IN HDEVINFO  DeviceInfoSet,
                  IN PSP_DEVINFO_DATA  DeviceInfoData,  OPTIONAL
                  IN LPGUID  InterfaceClassGuid,
                  IN DWORD  MemberIndex,
                  OUT PSP_DEVICE_INTERFACE_DATA  DeviceInterfaceData);

    typedef bool (__stdcall *pSetupDiDestroyDeviceInfoList)(IN void*);

    typedef bool (__stdcall *pSetupDiGetDeviceInterfaceDetail)
                 (IN HDEVINFO  DeviceInfoSet,
                  IN PSP_DEVICE_INTERFACE_DATA  DeviceInterfaceData,
                  OUT PSP_DEVICE_INTERFACE_DETAIL_DATA DeviceInterfaceDetailData,
                  IN DWORD  DeviceInterfaceDetailDataSize,
                  OUT PDWORD  RequiredSize,  OPTIONAL
                  OUT PSP_DEVINFO_DATA  DeviceInfoData  OPTIONAL);

    hSetupApi = LoadLibrary("C:\\Windows\\System32\\SETUPAPI.DLL");
    if (!hSetupApi)
      displayError("Bd doczenia biblioteki SETUPAPI.DLL.");

    pSetupDiGetClassDevs SetupDiGetClassDevsA = NULL;
    SetupDiGetClassDevsA = (pSetupDiGetClassDevs)GetProcAddress(hSetupApi,
                                                  "SetupDiGetClassDevsA");

    pSetupDiEnumDeviceInterfaces SetupDiEnumDeviceInterfaces = NULL;
    SetupDiEnumDeviceInterfaces = (pSetupDiEnumDeviceInterfaces)
               GetProcAddress(hSetupApi, "SetupDiEnumDeviceInterfaces");

    pSetupDiDestroyDeviceInfoList SetupDiDestroyDeviceInfoList = NULL;
    SetupDiDestroyDeviceInfoList = (pSetupDiDestroyDeviceInfoList)
         GetProcAddress(hSetupApi, "SetupDiDestroyDeviceInfoList");

    pSetupDiGetDeviceInterfaceDetail SetupDiGetDeviceInterfaceDetailA = NULL;
    SetupDiGetDeviceInterfaceDetailA = (pSetupDiGetDeviceInterfaceDetail)
         GetProcAddress(hSetupApi, "SetupDiGetDeviceInterfaceDetailA");

    if (!SetupDiGetClassDevsA || !SetupDiEnumDeviceInterfaces ||
        !SetupDiGetDeviceInterfaceDetailA || !SetupDiDestroyDeviceInfoList) {
       FreeLibrary(hSetupApi);
       displayError("Nie znaleziono funkcji eksportowych.");
    }

   deviceInfoSet = SetupDiGetClassDevsA(&GUID_DEVINTERFACE_USB_HUB,
                   NULL, NULL, DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE)
      displayError("Nie zidentyfikowano podczonych urzdze.\n");

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);

   while(SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL,
                                     &GUID_DEVINTERFACE_USB_HUB,
                                     memberIndex, &deviceInterfaceData)){
       memberIndex++; //inkrementacja numeru interfejsu


       SetupDiGetDeviceInterfaceDetailA(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);

       deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];

       deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);

       if (!SetupDiGetDeviceInterfaceDetailA(deviceInfoSet, &deviceInterfaceData,
                       deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
                       &requiredSize, NULL)){
           releaseMemory(deviceInterfaceDetailData);
           SetupDiDestroyDeviceInfoList(deviceInfoSet);
       }
       cout << deviceInterfaceDetailData->DevicePath << endl;
       releaseMemory(deviceInterfaceDetailData);
    };//koniec while
   SetupDiDestroyDeviceInfoList(deviceInfoSet);
   cout << endl;
   FreeLibrary(hSetupApi);
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------

